/*------------------------------------------------------------------------------*
 * File Name: Operation.h														*
 * Creation: YuI 11/25/2002													    *
 * Purpose: Origin C header	for Operation class and other related functions		*
 * Copyright (c) OriginLab Corp.2002											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 2/13/04 2/16/04 O8_OPERATION_REDO_USING_NEW_WORKBOOK					*
 *	ML 3/3/2004 RANGE_BASED_REGRESSIONS											*
 *	ML 5/6/2004 I don't see use for this any more								*
 *	ML 7/7/2004 QA70-6645 RESULT_COLUMNS_ADDED_TO_SOURCE_SHEET					*
 *	ML 7/27/2004 QA70-6667 RESULTS_LOG_AS_GRID									*
 *	CPY 8/8/04 BETTER_RESCALE_ON_FIT_GRAPHS										*
 *	YuI 8/13/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION						*
 *  SY 09/01/2004 QA70-6472 v8.0128 IMPORT_INFO_STORAGE_CLEANUP					*
 *  Forest 09/10/04 QA70-6682 SETTINGS_THEME_FILE_SAVE_LOAD                     *
 *  Iris 9/10/04 OUTPUT_ADD_2ND_GRAPH											*
 *  Iris 9/13/04 ADD_TABLE_BIT_TO_TREETABLE										*
 *  Iris 9/14/04 MOVE_INPUT_DATAPLOT_TO_BASE_CLASS								*
 *	CPY 9/23/04 MOVE_SET_TREE_TO_OC_ONLY										*
 *	ML 10/7/2004 MULTIPLE_DATASET_OPER_TREATMENT								*
 *	CPY 10/9/04 MOVE_THEME_SAVING_CODES_TO_EDIT									*
 *	ML 10/20/2004 QA70-7075 MASKED_DATA_REPORTING								*
 *  Danice 11/15/04 QA70-7169 v8.0163 TREE_ROW_SHOW_ALTERNATE_COLORS			*
 *	ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS						*
 *	YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT							*
 *	CPY 12/21/04 CLEANUP_ANOVA1_AND_USE_BASE_CLASS_FIX							*
 *	ML 1/26/2005 CUSTOM_TABLE_TO_GRAPH											*
 *	Frank 4/5/05	GUI_ADVANCED_SETTING_FROM_FILE								*
 *	Echo 4/8/05 MR_NEEDED														*
 *  Iris 4/12/05 MOVE_CURVE_OPTION_TO_EACH_GRAPH								*
 *	ML 6/9/2005 REPEATITIVE_STYLES_IN_GRID_THEMES								*
 *	ML 6/27/2005 STYLE_LINKS_WITH_OFFSETS										*
 *	ML 7/20/2005 FITTING_FUNCTION_FORMULA_IN_REPORT								*
 *	Kevin 08/29/05 ADD_GET_X_Y_DESIGNATION										*
 *  Iris 9/06/05 UPDATE_TABLE_STRING_FUN										*
 *	CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
 *	RVD 9/21/2005 QA70-8105 v8.0310 REPLACE_REPORT_COMPLETELY					*
 *	ML 10/13/2005 QA70-8157 SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS					*
 *	Kevin 10/17/05	SUPPORT_MORE_GRAPH_IN_REPORT_TREE							*
 *	ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE									*
 *	ML 10/26/2005 QA70-8225 ESCAPED_OPER_STRINGS_ANOVAS							*
 *	ML 11/1/2005 QA70-8254 INVOKING_OPERATION_FROM_XFUNCTION					*
 *	ML 11/2/2005 QA70-8135 MISSING_AND_MASKED_DATA_FOR_XYZ						*
 *	ML 11/8/2005 QA70-8135 Z_IN_REPORT_TABELS									*
 *	ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS									*
 *	Kevin 11/21/05	SET_EVENT_FOR_INPUT_DATA									*
 *	ML 1/31/2006 QA70-8141 UPDATING_TABLE_OBJECTS_IN_GRAPHS_FOR_ANALYSIS		*
 *	CPY RVD 3/23/2006 QA70-8359 TABLE_FOOTNOTE									*
 *  Alex 03/27/06 QA70_8551 DELECT_ERROR_COL_IF_NO_ERRORBAR_INPUT               *
 *	ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION							*
 *	ML 5/15/2006 SPECIAL_NLFITS_CUSTOM_TABLE									*
 *	ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY								*
 *	ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS				*
 *	ML 7/10/2006 QA70-8768 KEEPING_TRACK_OF_GRAPHS_CREATED_FROM_OPERATION		*
 *	Thomas 07/13/2006 FIX_MASKED_AND_MISSING_DATA_AUTO_UPDATE_ERROR				*
 *	ML 7/12/2006 REPORT_DATA_WITH_XF_WORKSHEET_GRAPHS_HANDLING					*
 *	ML 7/19/2006 REMEMBERING_SETTINGS_IN_XFOPERATION_FOR_AUTO_UPDATE			*
 *	ML 7/20/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY							*
 *	ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
 *	ML 7/25/2006 NEW_TABLE_ON_AUTOUPDATE_BUG									*
 *	CPY 07/24/06 QA70-8847 COLUMN_FORMULA_FROM_ORIGIN_C_REVAMP					*
 *	ML 7/26/2006 QA70-8856 PASTING_THEME_WITH_LINKS_OUTSIDE_OF_REPORT			*
 *	ML 8/4/2006 REMOVING_CUSTOM_TABLE											*
 *	ML 8/15/2006 ATTACHING_GRAPHS_TO_CELLS_IN_OPERATION							*
 *	ML 9/1/2006 NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL							*
 *	Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH						*
 *	ML 10/2/2006 NLFIT_CURVES_CLEANUP											*
 *  Arvin 10/13/06 MOVE_FUNCTIONS_FROM_STATSOPBASE_TO_WKSREPORTOPERATION		*
 *	Arvin 10/13/06 FITTING_RESIDUALS_HISTOGRAM_PLOT								*
 *	CPY 10/14/06 SEPARATE_OUT_OPERATION_BASE_INTO_SEPARATE_HEADER				*
 * 	Arvin 10/16/06 MOVE_TO_SUBCLASS												*
 *	ML 11/13/2006 THEME_DIGITS_PARAMETERS_TBL									*
 *  Iris 12/01/06 v8.0517 NOT_UPDATE_STATS_TABLE_AFTER_RECALCULATE				*
 *	ML 12/18/2006 CALLING_OPERATION_FROM_OC_LT									*
 *  Iris 01/03/2007 v8.0535 NOT_DEL_FIT_SESSION_POINTER_AFTER_CANCEL_CHANGE_PARAM_DLG*
 *	Jasmine 01/30/07 SHOULD_CHECK_DATARANGE_DATA_NUM							*
 *  Iris 02/13/2007 v8.0560 NEED_TO_REMOVE_THIS_NODE_AFTER_CREATE_REPORT		*
 *	Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX					*
 *	ML 4/5/2007 X_INPUT_MISSING_FROM_INPUT_DATA_TABLE							*
 *  Iris 04/18/2007 v8.0604 AFTER_APPLIED_THEME_GUI_ERR_WILL_SHOW_DLG			*
 *	Cheney 2007-4-20 OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN		*
 *	CPY 5/18/2007 QA70-9795 MENU_FROM_THEME_TO_OPEN_DIALOG						*
 *	Cheney 2007-6-6 SHOULD_LOAD_FACTORY_DEFAULT_THEME_FOR_OPERATION_TOOLS_WHEN_OPEN_DLG
 *	Arvin 06/29/07 v8.652 XOP_NEED_SUPPORT_NLFIT								*
 *	Arvin 09/03/07 WRONG_WEIGHT_LABEL_IN_MASK_AND_MISSING_DATA_TABLE			*
 *	ML 9/4/2007 QA70-10332 OPERATION_STATUS_UPDATE_ON_CHANGE_PARAMS				*
 *	Sim 11-05-2007 CLEAN_LOCALIZATION_CODE										*
 *	Arvin 11/10/07 XOP_NEED_SUPPORT_CHANGE_FUNCTION								*
 *	Folger 11/14/07 MAP_OPERATION_DIALOG_HELP									*
 *	CPY 11/19/2007 QA70-10708 OPERATION_NEED_VERSIONING_TO_FIX_BUGS_IN_OUR_CODE	*
 *	Hong 01/22/08 QA80-10929 LTNL_ACCESS_FITSESSION_PONTER						*
 *	Hong 01/24/08 QA80-10929 LT_NLFIT_SUPPORT_SOUURCE_GRAPHPAGE_PREVIEW			*
 *	Arvin 01/29/08 GENERATE_REPORT_FOR_LT_NLFit									*
 *	Arvin 01/29/08 GENERATE_REPORT_FOR_LT_NLFit									*
 *	Hong 02/01/08 v8.0798 FIX_CONTANTENATE_FIT_FAIL_WORK						*
 *	Jasmine 04/16/08 MOVE_UPDATE_MODEL_CODES_IN_FITNL_CLASS						*
 *	Folger 11/12/08 QA80-12488 v8.0969 CENTRALIZED_CODE_ABOUT_AUTO_UPDATE_MECHANISM_IN_WIZARD_OPERATION
 *	YuI 11/12/08 ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM					*
 *	Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET	*
 *	Folger 01/07/09 QA80-12925-P1 v8.0994b ORIGIN_CRASH_IN_PA_FITTING_WHEN_NEW_PROJECT
 *	Folger 02/16/09 QA80-13124 PDS_IN_OPJ_THAT_SAVED_IN_NONENLISH_ORIGIN_FAILS_TO_BE_RECOGNISZED_IN_ENGLISH_ORIGIN
 *	Folger 03/19/09 SHOULD_NOT_CLEAR_OUTPUTS_OF_PA_WHEN_AUTO_UPDATED			*
 *	Sophy 3/26/2009 QA80-13351 SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU
 *	Folger 03/27/09 ERPLOT_GRAPH_IS_NOT_SUPPORTED_FOR_PA_REPORT_SHEET						*
 *	Sophy 4/1/2009 MORE_WORK_ON_SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU
 *	Kyle 03/31/2009 QA80-3224 NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR	*
 *	Sim 04-02-2009 QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE	*
 *	Folger 07/01/09 QA80-13774-P1 COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
 *	Folger 07/31/09 QA80-13998 DESTROY_OPERATION_AND_ALL_RELATED_OUTPUTS		*
 *	Hong 09/04/09 QA80-14258 HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING	*
 *  Iris 9/27/2009 FIX_RESET_ALL_GRAPHS_WORK_FAILED								*
 *	Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION				*
 *	Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN			*
 *------------------------------------------------------------------------------*/
 
#pragma PCH //CPY 12/9/04

#ifndef _OPERATION_H
#define _OPERATION_H
  
#include <GetNBox.h>
#include <..\originlab\theme_utils.h>
#include <OperationBase.h> //CPY 10/14/06 SEPARATE_OUT_OPERATION_BASE_INTO_SEPARATE_HEADER in origin.h
#include <Range.h>

#include <oc_debug.h> //CPY 11/10/06 NLFIT_NEW_CODE_RUNTIME_ERR_ON_CANCEL_BUTTON

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
#include <..\Originlab\OutputGUIManager.h> 
#define	STR_OUTPUT_MANAGER_POINTER			"OutputManagerPtr"
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

#define CURRENT_OPERATION_VERSION 1	//----- CPY 11/19/2007 QA70-10708 OPERATION_NEED_VERSIONING_TO_FIX_BUGS_IN_OUR_CODE

///Arvin 01/29/08 GENERATE_REPORT_FOR_LT_NLFit
#define STR_LT_NLFIT_CLASS_ATTRIB   		"LTNLFitClass"
#define STR_NO_INIT_FROM_OP_ATTRIB  		"NOInitFromOperationTree"
#define OPERATION_FROM_LT_NLFIT_CALSS		1
#define NO_INIT_FIT_SESSION_FROM_OP_TREE   	1
///END GENERATE_REPORT_FOR_LT_NLFit

/// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
#define STR_FITTING_NO_FIT_AGAIN  			"FittingNoFitAgain" // Hong, No fit again if specified, force calculating of output if its value is 1
/// end NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN

///Arvin 03/27/07 QA70-9532 CALLING_SURFACE_FIT_FROM_OC_LT_AND_SUPPORT_MATRIX
//Operation error messages for doing nlfit from oc code  by CP's suggestion
enum 
{
	OP_NOERROR 									= 0,
	OP_WRONG_TYPE_DATA_RANGE 					= -1,
	OP_INVALID_INPUT_DATA_NODE 				= -2,
	OP_FAILED_GET_TREE_FROM_DATA_RANGE 			= -3,
	OP_FAILED_INIT_FROM_OPERATION_TREE 			= -4,
	OP_UNKNOWN_ERROR 							= -5,
	OP_MULTI_DATA_SET_NOT_SUPPORT_REPLICA 		= -6,
	OP_FUNCTION_NOT_SUPPORT_REPLICA				= -7,
	OP_NLSF_NOT_SELECT_FUNCTION					= -8,
	OP_GET_INPUT_DATARANGE_WRONG				= -9,
	OP_INVALID_PARAMETER_SETTING				= -10,	///Cheney/Arvin 2007-9-10 XOP_NEED_SUPPORT_PFM
	OP_WRONG_PFW_TREE_PEAKS_NODE				= -11,
	OP_WRONG_PFW_TREE_PARAMS_SETTINGS			= -12,
	OP_FAILED_GET_FUNC_PARAMS					= -13,
	OP_CAN_NOT_FIND_FUNC_FDF_FILE				= -14,
	OP_WRONG_PEAK_NUM							= -15,
	/// Hong 01/31/08 QA80-10929 LTNLFIT_MORE_DETAILS_ERROR_MSG
	OP_FAIL_LOAD_FDF_TO_TREE					= -16, 
	OP_NO_OPERATION_OBJECT						= -17,
	/// end LTNLFIT_MORE_DETAILS_ERROR_MSG
};
///end CALLING_SURFACE_FIT_FROM_OC_LT_AND_SUPPORT_MATRIX

///Arvin 02/21/08 QA70-10929 NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
enum
{
	OP_OUTPUT_NONE							= 0,
	OP_OUTPUT_REPORT_TABLES_TO_NOTES_WIN	= 0x0001,
	OP_OUTPUT_REPORT_TABLES_TO_SCRIPT_WIN	= 0x0002,
	OP_OUTPUT_REPORT_TABLES_TO_RESULT_LOG	= 0x0004,
	
	//------ Folger 11/12/08 QA80-12488 v8.0969 CENTRALIZED_CODE_ABOUT_AUTO_UPDATE_MECHANISM_IN_WIZARD_OPERATION
	OP_EXEC_CHANGE_PARAM					= 0x0100,
	//------
	///---Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
	OP_EXEC_SHOW_DLG_SETTINGS				= 0x0200,
	///---END QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
};
///end NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
class	ExternalLink : public OriginObject
{
};

class	FileLink : public	ExternalLink
{
public:	
	FileLink();
	FileLink(LPCSTR lpcszPath);
	~FileLink();

	void	Create(LPCSTR lpcszPath);
	void	Destroy();
	void	SetPath(LPCSTR lpcszPath);
	void	GetPath(string& strPath);
	string	GetPath();
};


#pragma message("including Operationb.h")

/// ML temp
//#include	<tree_utils.h>

/// YuI 11/27/07 QA70-10542 FIND_X_FROM_Y_SHOULD_ALLOW_OUTPUT_COLLISIONS
// moved to oUtils.h
/*
/// CPY ML 7/7/2004 QA70-6645 RESULT_COLUMNS_ADDED_TO_SOURCE_SHEET
enum {
	OUTPUT_REPORT_SHEET_RNG_INDEX,
	OUTPUT_RESULT_CURVE_SHEET_RNG_INDEX,
	/// Iris 10/13/06 v8.0495 OUTPUT_FIT_CURVE_TO_SOURCE_NOT_WORK
	OUTPUT_RESIDUAL_CURVE_SHEET_RNG_INDEX,
	OUTPUT_CALIBRATION_CURVE_SHEET_1_RNG_INDEX,
	OUTPUT_CALIBRATION_CURVE_SHEET_2_RNG_INDEX,
	///END OUTPUT_FIT_CURVE_TO_SOURCE_NOT_WORK
	OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX,
	//--------- CPY 11/26/04 OUTPUT_FIT_CURVES_TO_SOURCE_SHEET
	//OUTPUT_TOTAL_RNG_COUNT
	// the followings are not really used directly, so all additional output should be enumerated from OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX and any other output should be placed before OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX
	OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX_1,
	OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX_2,
	/// Iris 10/13/06 v8.0495 OUTPUT_FIT_CURVE_TO_SOURCE_NOT_WORK, findxy table cannot put into source data sheet.
	///// Joesph/Iris 9/26/06 QA70-7120 MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
	//OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX_3, 
	//OUTPUT_SRC_WKS_INSERTED_COLS_RNG_INDEX_4,
	/////end MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
	///end OUTPUT_FIT_CURVE_TO_SOURCE_NOT_WORK
	//---------
};

enum {
	OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET  = 1,
	OUTPUT_RESULT_CURVE_RESIDUAL_SHEET,	
	OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET,
	OUTPUT_RESULT_CURVE_CALIBRATION_FIND_Y_SHEET,
	OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET,
};
*/
/// end FIND_X_FROM_Y_SHOULD_ALLOW_OUTPUT_COLLISIONS
///Cheney 2007-1-30 MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC, move to oc_cnst.h
////--- CPY 12/6/04 SHOW_RANGE_TO_LABEL_FOR_MULTIPLE_RANGE_ON_SAME_DATA
//enum {ESC_LABEL_ADD_NONE, ESC_LABEL_ADD_RANGE, ESC_LABEL_ADD_INDEX};
///end MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC
//---
///---- CPY RVD 3/23/2006 QA70-8359 TABLE_FOOTNOTE
#define COMMON_TABLE_STR_BITS GETNBRANCH_RESIZE | GETNBRANCH_HIDE_CLIENT_EDGE | GETNBRANCH_SHOW_FRAME 
///---- end TABLE_FOOTNOTE

#define		TREE_INPUTRANGE_ADDITIONAL_DATA_NODE_NAME		"IRAdditionalData"
#define		OPERATION_ESCAPE_STRING_PREFIX					"?$OP:"
#define		TREE_STYLE_NODE_NAME							"Style"
#define		MULTIPLE_HEADING_RANGE_STYLE_NODE_NAME			"MultHead"
#define		MULTIPLE_HEADING_RANGE_STYLE					"ogLabel"

#define	WKSH_OPERATION_INFO_DATA_SOURCE						_L("Input Data Source")
/// ML 11/8/2005 QA70-8135 Z_IN_REPORT_TABELS
#define	WKSH_OPERATION_INFO_Z_DATA_SOURCE					_L("Input Z Data Source")
/// end Z_IN_REPORT_TABELS
///Arvin 08/17/07 ADD_WEIGHT_DATA_TABLE_IN_INPUT_DATA_TABLE
#define	WKSH_OPERATION_INFO_WEIGHT_DATA_SOURCE				_L("Weight Data")
///end ADD_WEIGHT_DATA_TABLE_IN_INPUT_DATA_TABLE
#define	WKSH_OPERATION_INFO_Y_DATA_SOURCE					_L("Input Y Data Source")
#define	WKSH_OPERATION_INFO_X_DATA_SOURCE					_L("Input X Data Source")
#define	WKSH_OPERATION_INFO_DATA_SOURCE_RANGE				_L("Range")
#define	WKSH_OPERATION_INFO_OPERATION_DESCRIPTION			_L("Description")
#define	WKSH_OPERATION_INFO_EXECUTION_TIME					_L("Operation Time")
#define	WKSH_OPERATION_INFO_USER_NAME						_L("User Name")
///Arvin 10/27/06 FITTING_FUNCTION_MODEL_IN_REPORT
#define WKSH_OPERATION_INFO_MODEL							_L("Model")
///end FITTING_FUNCTION_MODEL_IN_REPORT

/// Iris 8/14/2008 QA80-12017-S2 ADD_PARAM_NUM_DATA_NUM_TO_NOTE_TABLE
#define WKSH_OPERATION_INFO_NUM_PARAMS						_L("Number of Parameters")
#define WKSH_OPERATION_INFO_NUM_DERIVED_PARAMS				_L("Number of Derived Parameters")
#define WKSH_OPERATION_INFO_NUM_DATASETS					_L("Number of Datasets")
///END ADD_PARAM_NUM_DATA_NUM_TO_NOTE_TABLE

/// ML 7/20/2005 FITTING_FUNCTION_FORMULA_IN_REPORT
#define	WKSH_OPERATION_INFO_EQUATION						_L("Equation")
/// end FITTING_FUNCTION_FORMULA_IN_REPORT


/// ML 10/20/2004 QA70-7075 MASKED_DATA_REPORTING
#define	WKSH_OPERATION_INFO_DATA							_L("Data")
#define	WKSH_OPERATION_INFO_DATA_Y							_L("Y Data")
#define	WKSH_OPERATION_INFO_DATA_X							_L("X Data")
/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
#define	WKSH_OPERATION_INFO_DATA_Z							_L("Z Data")
/// end Z_IN_REPORT_TABELS
#define	WKSH_OPERATION_INFO_DATA_ERR						_L("Error")
#define	WKSH_OPERATION_INFO_DATA_WEIGHT						_L("Weight")
/// end MASKED_DATA_REPORTING

///Kyle 03/31/2009 QA80-3224 NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR
#define WKSH_OPERATION_INFO_X_WEIGHT_DATA_SOURCE			_L("X Weight Data")
#define	WKSH_OPERATION_INFO_Y_WEIGHT_DATA_SOURCE			_L("Y Weight Data")
///End NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR


class Operation : public OperationBase
{
public:
	//---------------------------------------------------------------
	//virtual 
	string	GetDescription(int nOptions)
	{
		Tree trOperation;
		GetTree(trOperation);
		bool bInput = nOptions & 1;// add to enum macros etc later
		bool bTime  = nOptions & 2; 
		return GetReportTitle(trOperation, bInput, bTime);// can add more options later
	}
	
	//---------------------------------------------------------------
	//virtual
	void	OnGetTree(TreeNode& tr)
	{
		return;
	}
	
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	//virtual
	///------ Folger 07/31/09 QA80-13998 DESTROY_OPERATION_AND_ALL_RELATED_OUTPUTS
	//void	DestroyInternal()
	void	DestroyInternal(BOOL bDeleteOutputs = FALSE)
	///------ End DESTROY_OPERATION_AND_ALL_RELATED_OUTPUTS
	{
		CleanupOutputManager("DestroyInternal");
		///------ Folger 07/31/09 QA80-13998 DESTROY_OPERATION_AND_ALL_RELATED_OUTPUTS
		//OperationBase::DestroyInternal();
		OperationBase::DestroyInternal(bDeleteOutputs);
		///------ End DESTROY_OPERATION_AND_ALL_RELATED_OUTPUTS
	}
	
	void	CleanupOutputManager(LPCSTR lpcszMsg)
	{
		if(m_pOutputManager)
		{
			_DBPRINTF("**** m_pOutputManager not NULL when %s, deleting...\n", lpcszMsg);
			delete m_pOutputManager;
			m_pOutputManager = NULL;
		}
		else
		{
			_DBPRINTF("**** m_pOutputManager is NULL when %s\n", lpcszMsg);
		}		
	}
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	
	virtual string	GetReportTitle(TreeNode& trOp = NULL, bool bAddInput = true, bool bAddTime = true) // for window title and for context menu to list operation
	{
		Tree trOp1;
		TreeNode trOperation;
		if(trOp)
			trOperation = trOp;
		else
		{
			GetTree(trOp1);
			trOperation = trOp1;
		}
			
		string strRet = GetResultDescription(trOperation); //,false);
		if(bAddInput)
		{
			string strInput = GetInputDisplay(false);
			if(!strInput.IsEmpty())
				strRet += ", " + strInput;
		}
		if(bAddTime)
		{
			TreeNode trHeaderTable = GetTreeNode_Notes(trOperation);
			if(trHeaderTable.Time.IsValid())
				strRet += " (" + trHeaderTable.Time.strVal + ")";
		}
		
		return strRet;
	}
	/**
		carry out the calculation
		Parameter:
			dwExecCntrl = bits to control the calculation details if any, for example OPEXEC_NO_PARAM_INIT
		Example:
		#include <Origin.h>
		#include <operation.h>
		
		bool tt(string strX = "A", string strY = "B", string strClass = "FitLinear")
		{
			Worksheet wks = Project.ActiveLayer();
			if(!wks)
				return error_report("No active worksheet");
			bool bOK;
		
			int nOption = 0;
			Operation& op = (Operation &)op_create(strClass, bOK, nOption); 
			if(op == NULL)
				return error_report("invalid analysis class");
			
			Tree trOp;
			op.GetTree(trOp);
			// first setup input data
			if(!make_input_data(trOp.GUI.InputData, wks, strX, strY))
				return error_report("failed setting up input data");
			
			bool bAutoUpdate = false;
			op.OnNoEdit(nOption, bAutoUpdate, NULL);
			op.SetTree(trOp);
			op.Calculate();
			op.GetTree(trOp);
			op.FilterReportForStrDump(trOp);
			string strOut;
			vector<int> vnTableDisplayFormat = { DISPLAY_CENTER, DISPLAY_RIGHT, DISPLAY_RIGHT};
			tree_to_str(trOp.Calculation, strOut,vnTableDisplayFormat);
			LT_execute("type -a");
			out_str(strOut);
			
			op_destroy_on_cancel(op);
			return true;
		}			
		
		bool tt2(string strRange = "(1,2)", string strClass = "FitLinear")
		{
			bool bOK;
			int nOption = 0;
			Operation& op = (Operation &)op_create(strClass, bOK, nOption); 
			if(op == NULL)
				return error_report("invalid analysis class");
			
			Tree trOp;
			op.GetTree(trOp);
			if(!make_input_data(trOp.GUI.InputData, strRange))
				return error_report("failed setting up input data");
			
			bool bAutoUpdate = false;
			op.OnNoEdit(nOption, bAutoUpdate, NULL);
			op.SetTree(trOp);
			op.Calculate();
			op.GetTree(trOp);
			op.FilterReportForStrDump(trOp);
			string strOut;
			vector<int> vnTableDisplayFormat = { DISPLAY_CENTER, DISPLAY_RIGHT, DISPLAY_RIGHT};
			tree_to_str(trOp.Calculation, strOut,vnTableDisplayFormat);
			LT_execute("type -a");
			out_str(strOut);
			
			op_destroy_on_cancel(op);
			return true;
		}			
	*/
	///Arvin 02/21/08 QA70-10929 NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
	//virtual int Calculate(DWORD dwExecCntrl = 0) { return -1;} // indicates error
	virtual int Calculate(DWORD dwExecCntrl = 0, DWORD dwOutputCntrl = OP_OUTPUT_NONE) { return -1;} // indicates error
	///end NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
	virtual void FilterReportForExternal(TreeNode& trOp) {} ///----- CPY 3/31/2007 NLFIT_REPORT_FROM_OC
	//---------------------------------------------------------------
	//virtual
	BOOL	Init(const TreeNode &tr)
	{
		SetTree(tr);
		return TRUE;
	}
		//----
	BOOL Init(int nOption = 0)
	{
		// Create tree
		Tree		trOperation;

		if( !Construct(trOperation, nOption) )
			return FALSE;
		/* CPY 11/2/04 INIT_FROM_SEL_MOVED_TO_OPERATION_TO_GUI
		if (bSetDefaultInput)
		{
			// Init from selection:
			//TreeNode		trGUI = trOperation.GUI;
			InitFromSelection(trOperation);
		}
		*/
		///---Sim 04-02-2009 QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE
		m_mvCur.UpdateTreeAttribute(trOperation, STR_OP_INDV_VERSION, true);
		///---END QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE
		SetTree(trOperation);
		//---- CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH
		//return IsOpenGUIOnlyShiftDown();
		return true;
		//----
	}
	//---------------------------------------------------------------
	//----------- TD 6-18-04 QA70-6361 GET_OPERATION_FROM_HITTEST
	/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
	/*
	virtual bool OnOpenGraph(int nIndex = 0, uint nRowID = 0)
	{
		GraphPage gp;
		gp.Create();
		return true;
	}
	*/
	virtual bool OnOpenGraph(uint nGraphNodeID, int nPictureIndex = 0)
	{
		return true;
	}
	/// end PICTURE_IN_REPORT_IMPROVEMENT
	
	/// ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
	bool DoOpenGraph(const vector<uint>& vNodeRef, int nRow, int nCol)
	{
		//most Graphs are shown horizontally, so nCol is the index, but we need
		//better mechanism later to get that info
		int nLastIndex = vNodeRef.GetSize() - 1;
		if(nLastIndex >= 1)
		{
			uint nLastID = vNodeRef[nLastIndex];
			uint nTableID = vNodeRef[nLastIndex-1];
			if(	nTableID >= IDST_RESULT_GRAPHS && nTableID <= IDST_RESULT_GRAPHS + 20)
				return OnOpenGraph(nTableID, nCol);
			else
				printf("Table ID = %d, Row id = %d\n", nTableID, nLastID);
		}
		return false;
	}

	virtual bool OnButtonClick(const vector<uint>& vNodeRef, int nRow, int nCol)
	{
		#ifdef		__BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
		return DoOpenGraph(vNodeRef, nRow, nCol);
		#else		// !__BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
		return false;
		#endif		// !__BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
	}
	/// end BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS

	
	virtual bool OnDblClick(const vector<uint>& vNodeRef, int nRow, int nCol)
	{
		/// ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
		/*
		//most Graphs are shown horizontally, so nCol is the index, but we need
		//better mechanism later to get that info
		int nLastIndex = vNodeRef.GetSize() - 1;
		if(nLastIndex >= 1)
		{
			uint nLastID = vNodeRef[nLastIndex];
			uint nTableID = vNodeRef[nLastIndex-1];
			if(	nTableID >= IDST_RESULT_GRAPHS && nTableID <= IDST_RESULT_GRAPHS + 20)
				return OnOpenGraph(nTableID, nCol);
			else
				printf("Table ID = %d, Row id = %d\n", nTableID, nLastID);
		}
		return false;
		*/
		#ifndef		__BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
		return DoOpenGraph(vNodeRef, nRow, nCol);
		/// end BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
		#else		// __BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
		return false;
		#endif		// __BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
		/// end BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
	}
	//-----------
	//---------------------------------------------------------------
	//virtual bool OnEdit(curvebase& cv, TreeNode& trOperation, BOOL bChangeParams) {return false;}
	
	//---- CPY 07/24/06 QA70-8847 COLUMN_FORMULA_FROM_ORIGIN_C_REVAMP
	//bool Edit(bool bChangeParams, bool& bAutoUpdate, LPCSTR lpcszTheme, bool bInitFromSel = true);
	//bool Edit(bool bChangeParams, int& nAutoUpdate, LPCSTR lpcszTheme, bool bInitFromSel = true);
	//----
	//---------------------------------------------------------------
	//virtual
	//-------- CPY 5/18/2007 QA70-9795 MENU_FROM_THEME_TO_OPEN_DIALOG
	//void	OnNoEdit(int nOption, int& nAutoUpdate, LPCSTR lpcszTheme = NULL, bool bSetDefaultInput = false, DWORD dwAuxData = 0) // if no GUI open and proceed directly to execute
	bool	OnNoEdit(int nOption, int& nAutoUpdate, LPCSTR lpcszTheme = NULL, bool bSetDefaultInput = false, DWORD dwAuxData = 0) // if no GUI open and proceed directly to execute
	//--------
	{
		Tree trOperation;
		GetTree(trOperation);
		int nWasAutoUpdateInGui = trOperation.GUI.AutoUpdate.nVal; 
		int nNewOPMode;
		if(lpcszTheme)
		{
			string strSelTheme = lpcszTheme;
			///Cheney 2007-7-18 CLEAN_UP_ERR_HANDLING
			//OperationtoGUI(trOperation, true, &strSelTheme, bSetDefaultInput);
			if(!OperationtoGUI(trOperation, true, &strSelTheme, bSetDefaultInput))
				return false;
			///end CLEAN_UP_ERR_HANDLING
			nNewOPMode = GUI_OP_NEW_NO_EDIT;
			
			/// Iris 04/18/2007 v8.0604 AFTER_APPLIED_THEME_GUI_ERR_WILL_SHOW_DLG
			PEVENT_GETN	pfnGetNEvent = GetNewEventFunction();
			if(pfnGetNEvent)
			{
				DWORD			dwEnables;
				WndContainer	getNContainer;
				string 			strNodeName, strAux, strErrMsg;
				///Cheney 2007-6-6 SHOULD_LOAD_FACTORY_DEFAULT_THEME_FOR_OPERATION_TOOLS_WHEN_OPEN_DLG
				//pfnGetNEvent(trOperation.GUI, -1, 0, dwEnables, NULL, getNContainer, strAux, strErrMsg);
				pfnGetNEvent(trOperation.GUI, -1, GETNE_ON_INIT, dwEnables, NULL, getNContainer, strAux, strErrMsg);
				///end SHOULD_LOAD_FACTORY_DEFAULT_THEME_FOR_OPERATION_TOOLS_WHEN_OPEN_DLG
				if( !strErrMsg.IsEmpty() )
				{
					if(ShowDlg(trOperation, false))
					{
						nNewOPMode = GUI_OP_NEW;
					}
					//-------- CPY 5/18/2007 QA70-9795 MENU_FROM_THEME_TO_OPEN_DIALOG
					else
						return false;
					//-------
				}
			}
			///END AFTER_APPLIED_THEME_GUI_ERR_WILL_SHOW_DLG
		}
		else
		{
						//--- CPY 8/17/05 NLFIT_SEL_PARTIAL_RANGE_OK_BUTTON_BECOMES_FULL_RANGE, added bSetDefaultInput to pass through into OperationtoGUI
			///Cheney 2007-7-18 CLEAN_UP_ERR_HANDLING
			//OperationtoGUI(trOperation, true, NULL, bSetDefaultInput); // do not load anything or update anything related to theme
			if( !OperationtoGUI(trOperation, true, NULL, bSetDefaultInput)) // do not load anything or update anything related to theme
				return false;
			nNewOPMode = GUI_OP_NEW;// edit was done outside, theme info already in tree
		}
		
		//---- CPY 12/2/04 AUTO_UPDATE_ALLOW_THEME_CONTROL,
		//if(lpcszTheme)
		//	trOperation.GUI.AutoUpdate.nVal = nWasAutoUpdateInGui;
		//---
		
		/// Iris 02/13/2007 v8.0560 SHOULD_SUPPORT_AUTOUPDATE_WHEN_SELECT_THEME_FROM_MENU, by Max's design
		///end SHOULD_SUPPORT_AUTOUPDATE_WHEN_SELECT_THEME_FROM_MENU
		
		nAutoUpdate = trOperation.GUI.AutoUpdate.nVal;
			
		if(GUItoOperation(trOperation, nNewOPMode))
		{
			SetTree(trOperation);
			return true;
		}
		else
		{
			error_report("GUItoOperation failed");
			return false;
		}
	}

	
	/// ML 12/18/2006 CALLING_OPERATION_FROM_OC_LT
	//virtual	BOOL	OnInitDataFromOCLT(TreeNode &trOp, TreeNode& trInputData, LPCSTR lpcszX, LPCSTR lpcszY)
	//		{ return FALSE; }
	///Arvin 03/27/07 QA70-9532 CALLING_SURFACE_FIT_FROM_OC_LT
	//virtual	BOOL	OnInitDataFromOCLT(TreeNode &trOp, TreeNode& trInputData, XYRange &xyrng, LPCSTR lpcszStr1 = NULL, LPCSTR lpcszStr2 = NULL)
	//		{ return FALSE; }
	///Arvin 01/29/08 SHOULD_NOT_ADD_USER_PARAM_SETTING_TREE_IN_CLASS_LT_NLFit
	//virtual	int	OnInitDataFromOCLT(TreeNode &trOp, TreeNode& trInputData, DataRange &dr, LPCSTR lpcszStr1 = NULL, LPCSTR lpcszStr2 = NULL)
	///------- Folger 07/01/09 QA80-13774-P1 COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
	//virtual	int	OnInitDataFromOCLT(TreeNode &trOp, TreeNode& trInputData, DataRange &dr, LPCSTR lpcszStr1 = NULL, LPCSTR lpcszStr2 = NULL, bool bNeedUserParamSetting = true)
	virtual	int	OnInitDataFromOCLT(TreeNode &trOp, TreeNode& trInputData, DataRange &dr, LPCSTR lpcszStr1 = NULL, LPCSTR lpcszStr2 = NULL, bool bNeedUserParamSetting = true, TreeNode& trOriginalInput = NULL)
	///------- End COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
	///end SHOULD_NOT_ADD_USER_PARAM_SETTING_TREE_IN_CLASS_LT_NLFit
		{ return OP_UNKNOWN_ERROR; }
	///end CALLING_SURFACE_FIT_FROM_OC_LT
	/// end CALLING_OPERATION_FROM_OC_LT
	
	///Arvin 06/29/07 v8.652 XOP_NEED_SUPPORT_NLFIT
	virtual int OnInitOperationTreeFromOCLT(TreeNode &trOp, TreeNode& trOCLT, bool bInitTree = true){ return OP_UNKNOWN_ERROR;}
	///end XOP_NEED_SUPPORT_NLFIT
	
	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	bool	ReplotReportGraphs()
	{
		Tree trOp;
		GetTree(trOp);
		
		/// Iris 9/27/2009 FIX_RESET_ALL_GRAPHS_WORK_FAILED
		// #14138 cause this report becuase in order to keep stats on col operation smaller, then remove all hidden nodes in trOp tree. 
		// Plot Info node is hidden, so before replot graph, need to reconsturct plot info nodes.
		TreeNodeCollection trGraphs(trOp.Calculation, "Graph");
		int nGraphIndex = 0;
		foreach(TreeNode trGraph in trGraphs)
		{
			if( trGraph.Show ) // hidden graph nodes no need to take care
			{
				TreeNode trPlotInfo;
				bool bRet = checkCreateImagInfoSubNodes(trOp, nGraphIndex, trPlotInfo);
				ASSERT(bRet && trPlotInfo);
			}
			nGraphIndex++;
		}
		///end FIX_RESET_ALL_GRAPHS_WORK_FAILED
			
		return addGraphsToReport(trOp, NULL, NULL, true);
	}
	//------ End SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	
	virtual	bool	IsReplotGraphsSupported()			{ return true; }		///------ Folger 03/27/09 ERPLOT_GRAPH_IS_NOT_SUPPORTED_FOR_PA_REPORT_SHEET
	
	///Sophy 3/26/2009 QA80-13351 SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU
	///Sophy 4/1/2009 MORE_WORK_ON_SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU
	virtual	int	GetTotalNumData(TreeNode& trOp){return -1;}
	virtual bool	IsRearrangeGraphSupported()
	{
		Tree trOperation;
		GetTree(trOperation);
		if ( GetTotalNumData(trOperation) <= 1 )
			return false;
		
		/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//TreeNode trPlotSettings = trOperation.GUI.Output.PlotSettings;//this code is safe even though GUI or Output node doesn't exists!
		TreeNode trPlotSettings = OP_GUI_GRAPH_ARRANGEMENT_NODE(trOperation.GUI);
		///end OP_DLG_NEW_STRUCTURE
		if ( trPlotSettings )
			return trPlotSettings.Show;
		
		return false;
	}
	///end MORE_WORK_ON_SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU
	bool	RearrangeReportPlots(Worksheet& wks)
	{
		Tree trOperation;
		GetTree(trOperation);
		/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//TreeNode trPlotInOneGraph = trOperation.GUI.Output.PlotSettings.PlotInOneGraph;
		TreeNode trPlotInOneGraph = OP_GUI_GRAPH_ARRANGEMENT_NODE(trOperation.GUI).PlotInOneGraph;
		///end OP_DLG_NEW_STRUCTURE
		if ( trPlotInOneGraph )
		{
			int nCheck = trPlotInOneGraph.nVal;
			trPlotInOneGraph.nVal = (nCheck != 1); //inverse check state
		}
		/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
		TreeNode trGraphInfo = trOperation.Calculation.GraphInfo;
		if( trGraphInfo )
			trGraphInfo.Reset();
		///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
		prepareGraphNodes(trOperation);
		addGraphsToReport(trOperation, wks, NULL, true);
		SetTree(trOperation);
		//update report tree
		DWORD dwReportUID = filterAndGenerateReport(wks, trOperation.Calculation, 0, TRUE, TRUE);
		return (dwReportUID != 0);
	}
	///end SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU
	virtual		string	GetGraphTemplate(int nGraphIndex = 0)		{ return ""; }
	
private:
	void doChangeParam();// CPY 9/24/04, there is some bug, we cannot call from VC to an OC function that is implememted in separate .c file yet
	
	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	virtual	bool	addGraphsToReport(TreeNode& trOp, Worksheet& wksReport, DataRange& rgReportSheetOutput = NULL, bool bReplot = false)	{ return false; }
	//------
	///Sophy 3/26/2009 QA80-13351 SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU
	virtual	void	prepareGraphNodes(TreeNode& trOp, int nGraphIndex = -1){return;}
	virtual	DWORD	filterAndGenerateReport(Datasheet& ds, TreeNode& trReport, int nNumInHeading = 0, BOOL bCheckIDRange = TRUE, BOOL bHierarchy = FALSE, int nOuputOption = OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET){return 0;}
	///end SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU
	
	/// Iris 9/27/2009 FIX_RESET_ALL_GRAPHS_WORK_FAILED
	virtual bool	checkCreateImagInfoSubNodes(TreeNode& trOp, int nGraphIndex, TreeNode& trPlotInfo) { ASSERT(0); return false;}
	///end FIX_RESET_ALL_GRAPHS_WORK_FAILED
	
public:
	//virtual 
	/// ML 9/4/2007 QA70-10332 OPERATION_STATUS_UPDATE_ON_CHANGE_PARAMS
	//BOOL	ChangeParam()	
	// Returns:
	//		< 0 - Cancel
	//		= 0 - Failure
	//		> 0 - Success
	int		ChangeParam()	
	/// end OPERATION_STATUS_UPDATE_ON_CHANGE_PARAMS
	{
		//---CPY 10/15/06
		/*
		doChangeParam();// CPY 9/24/04, there is some bug, we cannot call from VC to an OC function that is implememted in separate .c file yet
		//bool bAutoUpdate = true;
		*/
		
		/// YuI 10/18/06 the code below was commented out by CP
		// so change param did not do anything
		// CP will have to review my "uncommenting"
		int nAutoUpdate = AU_ON_COMMAND;
		bool bOK = Edit(true, nAutoUpdate, NULL);
		/// ML 9/4/2007 QA70-10332 OPERATION_STATUS_UPDATE_ON_CHANGE_PARAMS
		//if(bOK)
		//	Execute(OEXEM_ON_CHANGEPARAM);
		int			nRet = -1;		// Cancelled
		if(bOK)
		{
			if ( Execute(OEXEM_ON_CHANGEPARAM) )
				nRet = 1;		// OK
			else
				nRet = 0;		// Failed
		}
		/// end OPERATION_STATUS_UPDATE_ON_CHANGE_PARAMS
		/// end YuI
			
		/// Iris 01/03/2007 v8.0535 NOT_DEL_FIT_SESSION_POINTER_AFTER_CANCEL_CHANGE_PARAM_DLG
		// To fix: click Change Parameter to open NLSF dialog, and click Cancel, always remained two hidden worksheet in PE
		OnKeepOpAfterExecute();
		///END NOT_DEL_FIT_SESSION_POINTER_AFTER_CANCEL_CHANGE_PARAM_DLG
		/// ML 9/4/2007 QA70-10332 OPERATION_STATUS_UPDATE_ON_CHANGE_PARAMS
		//return true;
		return nRet;
		/// end OPERATION_STATUS_UPDATE_ON_CHANGE_PARAMS
	}

	//---------------------------------------------------------------
	/// ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE
	virtual	int		GetDRTreeOption(TreeNode &trOperation)
		{ return DRTREE_DEFAULT; }
	/// end ANOVA_INPUT_DATA_TO_DATARANGE
	/*
	//---------------------------------------------------------------
	//virtual
	BOOL EditReportingSettings(HWND hWndPage)
	{
		Tree trOperation;
		GetTree(trOperation);
		P_REPORT_SETTINGS_DLG pfn = Project.FindFunction("ReportSettings");
		if(pfn)
		{
			if(pfn(trOperation.Reporting.Settings, hWndPage))
			//if(pfn(trOperation.Reporting, hWndPage))
			{
				SetTree(trOperation);
				return true;
			}
		}
		return false;
	}
	*/

	//virtual
	BOOL OnBeforeClose(BOOL bSysCommand, BOOL bAskUser, BOOL& bDelete)
	{
		if ( bAskUser && ( OM_RETURN_OK == OptionalMessage( "DestroyOperationWithSource", MB_YESNO ) ) )
			bDelete = TRUE;
		return TRUE;
	}
	
	///Iris 6/03/05 CENTRALIZE_TO_GET_GRAPH_GUI_NODE, move this to WksReportOperation class
	/*
	virtual uint GetCurveLineColor(const TreeNode& trOp, int nCurveIndex = 0) 
	{
		///Iris 6/03/05 CENTRALIZE_TO_GET_GRAPH_GUI_NODE
		///Iris 4/12/05 MOVE_CURVE_OPTION_TO_EACH_GRAPH
		//TreeNode trCurves = trOp.GUI.Output.Data.ResultCurves;
		//TreeNode trCurves = GetCurveOptions(trOp.GUI, nCurveIndex);
		TreeNode trCurves = GetGUIGraphNodes(trOp, nCurveIndex);
		///end CENTRALIZE_TO_GET_GRAPH_GUI_NODE
		if(trCurves.IsValid() && trCurves.CurveColor.IsValid())
			return trCurves.CurveColor.nVal;

		return 0;
	}
	*/
	
	/// Iris 5/19/05 move this function to WksReportOperation class
	/*
	///Iris 4/14/05 UPDATE_GRAPH_LEGEND
	bool SetupPlotDetails(const TreeNode& trOp, GraphLayer& gl, DataPlot& dp, int nGraphIndex = 0)
	{
		if( !gl )
			return false;		
		
		//Setup Color
		if( dp )
			dp.SetColor(GetCurveLineColor(trOp, nGraphIndex));		
		
		TreeNode trOptions = GetCurveOptions(trOp.GUI, nGraphIndex);
		if( !trOptions )
			return false;
		
		//Update Graph Legend
		TreeNode trLegend = trOptions.Legend;
		bool bUpdateLegend = trLegend? trLegend.nVal : false;
		if(bUpdateLegend)
			gl.LT_execute("legend -s");
		
		return true;
	}
	*/
	
	///------ Folger 01/07/09 QA80-12925-P1 v8.0994b ORIGIN_CRASH_IN_PA_FITTING_WHEN_NEW_PROJECT
	virtual		void	SetHelperClass(void* pHelper)		{}
	///------ End ORIGIN_CRASH_IN_PA_FITTING_WHEN_NEW_PROJECT
	
public:
	///Iris 6/03/05 UPDATE_ANALYSIS_GUI_STRUCTURE
	/////Iris 4/12/05 MOVE_CURVE_OPTION_TO_EACH_GRAPH
	//TreeNode GetCurveOptions(const TreeNode& trGUI, int nGraphIndex = 0)
	//{
		//TreeNode trGraphOption;
		//TreeNode trCreate = trGUI.Output.Report.Create;
		//if(trCreate)
		//{
			//nGraphIndex++;
			//trGraphOption = trCreate.GetNode("Graph" + nGraphIndex);
		//}
		//
		//return trGraphOption;
		//
	//}
	///end UPDATE_ANALYSIS_GUI_STRUCTURE
	
	// return true if output data range as well as output worksheet are both valid
	/// Iris 9/06/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
	//bool	GetOutput(DataRange& rgOutput, Worksheet& wksOutput, int nOutputIndex = OUTPUT_REPORT_SHEET_RNG_INDEX)
	bool	GetOutput(DataRange& rgOutput, Datasheet& dsOutput, int nOutputIndex = OUTPUT_REPORT_SHEET_RNG_INDEX)
	{
		if(dsOutput.IsValid())  
			error_report("calling GetOutput with valid worksheet or matrixlayer, please fix");
		
		return op_get_output(*this, rgOutput, dsOutput, nOutputIndex);
	}
	
	/// ML 6/27/2005 STYLE_LINKS_WITH_OFFSETS
	virtual	BOOL	GetCustomTableThemeClassName(string &strThemeName, int nCustomIndex = 0) {return false;}
	
	/// end STYLE_LINKS_WITH_OFFSETS
	
	///Arvin 11/10/07 XOP_NEED_SUPPORT_CHANGE_FUNCTION
	virtual void    ClearOutputTables(TreeNode& trOperation)
	{
		bool		bKeepAttrib = true;
		TreeNode 	trOut = trOperation.Calculation;
		if(trOut.Input)
			trOut.Input.Reset(bKeepAttrib);
		if(trOut.MaskedData)
			trOut.MaskedData.Reset(bKeepAttrib);
		if(trOut.MissingData)
			trOut.MissingData.Reset(bKeepAttrib);
		/// Iris 02/13/2007 v8.0560 NEED_TO_REMOVE_THIS_NODE_AFTER_CREATE_REPORT
		if(trOut.GraphInfo)
			trOut.GraphInfo.Reset(bKeepAttrib);
		///end NEED_TO_REMOVE_THIS_NODE_AFTER_CREATE_REPORT
		
		/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
		/*
		TreeNodeCollection trGraphs(trOut, "Graph");
		foreach(TreeNode trGraph in trGraphs)
			trGraph.Reset(bKeepAttrib);
		*/
		/// Iris 08/02/2007 v8.0673 QA70-10073 FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
		// get back the original codes to remove graph treenodes, just need to keep report page and save its UID, 
		// after recalculation, just need to reconstruct graph treenodes and find original page by UID and put back to new graph treenodes
		TreeNodeCollection trGraphs(trOut, "Graph");
		foreach(TreeNode trGraph in trGraphs)
			trGraph.Reset(bKeepAttrib);
		///end FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT	
		///end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	}
	///end XOP_NEED_SUPPORT_CHANGE_FUNCTION
protected:
	BOOL	Construct(TreeNode& trOperation, int nOption = 0)
	{
		error_report("Should not come to Operation::Construct");
		return false;
	}
	///---Sim 04-02-2009 QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE
	MultipleVersion		m_mvCur;
	void SetIndividualVersion(TreeNode& trOperation, const MultipleVersion& mv)
	{
		mv.UpdateTreeAttribute(trOperation, STR_OP_INDV_VERSION, true);
	}
	bool GetIndividualVersion(const TreeNode& trOperation, MultipleVersion& mv)
	{
		return mv.UpdateTreeAttribute(trOperation, STR_OP_INDV_VERSION, false);
	}
	///---END QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE
	/// YuI 09/27/06 TWO_WAY_ANOVA_TREE_RESOLUTION_SCREWUP
	virtual void	GetRelevantInputDataTreeNode(TreeNode& trOp, TreeNode& trRelevant, TreeNode& trInputData)
	{
		trRelevant = trInputData;
	}
	/// end TWO_WAY_ANOVA_TREE_RESOLUTION_SCREWUP
	
	///Iris 01/20/05 CONSTRUCT_GUI_CLEANUP
	//virtual TreeNode ConstructGUI()
	virtual TreeNode ConstructAddGUI(TreeNode& trOperation)
	{		
		GETN_OPERATION(trGUI)
		GETN_OPTION_GRIDLINE(flexGridFlatVert)
		GETN_OPTION_EDIT_ALIGN("0|0|0")
		ConstructAddCommonTop(trGUI);
		
		///Danice TREE_ROW_SHOW_ALTERNATE_COLORS
		string strColors, strSpecialIndicatorColors;
		get_analysis_gui_color(strColors, strSpecialIndicatorColors);
		trGUI.SetAttribute(STR_ATTRIB_TREE_ROW_COLOR, strColors);
		trGUI.SetAttribute(STR_ATTRIB_TREE_INDICATOR_COLOR, strSpecialIndicatorColors);
		///end TREE_ROW_SHOW_ALTERNATE_COLORS
		
		trOperation.AddNode(trGUI.Clone());  ///Iris 01/20/05 CONSTRUCT_GUI_CLEANUP
		
		//return trGUI;
		return trOperation.GUI;
	}
	
	///------ Folger 03/19/09 SHOULD_NOT_CLEAR_OUTPUTS_OF_PA_WHEN_AUTO_UPDATED
	virtual	BOOL	IsSkipCleanOutputBeforeCalculations()		{ return FALSE; }
	///------ End SHOULD_NOT_CLEAR_OUTPUTS_OF_PA_WHEN_AUTO_UPDATED
	
	//---- CPY 5/6/04 HISTOGRAM_GRAPHS
	/// Iris 11/16/06 CLEAR_OUT_TABLES_BEFORE_CALC_WHEN_DO_CHANGE_PARAMS
	//virtual void	OnBeforeCalculations(TreeNode& trOperation) {}
	virtual void	OnBeforeCalculations(TreeNode& trOperation, int nExeMode)
	{
		//---- Iris 12/01/06 v8.0517 NOT_UPDATE_STATS_TABLE_AFTER_RECALCULATE
		//if(OEXEM_ON_CHANGEPARAM == nExeMode)
		///------ Folger 03/19/09 SHOULD_NOT_CLEAR_OUTPUTS_OF_PA_WHEN_AUTO_UPDATED
		//if( nExeMode > OEXEM_ON_CREATE )
		if( nExeMode > OEXEM_ON_CREATE && !IsSkipCleanOutputBeforeCalculations() )
		///------ End SHOULD_NOT_CLEAR_OUTPUTS_OF_PA_WHEN_AUTO_UPDATED
		//----
			ClearOutputTables(trOperation);
	}
	///Arvin 11/10/07 XOP_NEED_SUPPORT_CHANGE_FUNCTION
	//Need call this method from oc code, so move it to public session
	//virtual void    ClearOutputTables(TreeNode& trOperation)
	//{
		//bool		bKeepAttrib = true;
		//TreeNode 	trOut = trOperation.Calculation;
		//if(trOut.Input)
			//trOut.Input.Reset(bKeepAttrib);
		//if(trOut.MaskedData)
			//trOut.MaskedData.Reset(bKeepAttrib);
		//if(trOut.MissingData)
			//trOut.MissingData.Reset(bKeepAttrib);
		///// Iris 02/13/2007 v8.0560 NEED_TO_REMOVE_THIS_NODE_AFTER_CREATE_REPORT
		//if(trOut.GraphInfo)
			//trOut.GraphInfo.Reset(bKeepAttrib);
		/////end NEED_TO_REMOVE_THIS_NODE_AFTER_CREATE_REPORT
		//
		///// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
		///*
		//TreeNodeCollection trGraphs(trOut, "Graph");
		//foreach(TreeNode trGraph in trGraphs)
			//trGraph.Reset(bKeepAttrib);
		//*/
		///// Iris 08/02/2007 v8.0673 QA70-10073 FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
		//// get back the original codes to remove graph treenodes, just need to keep report page and save its UID, 
		//// after recalculation, just need to reconstruct graph treenodes and find original page by UID and put back to new graph treenodes
		//TreeNodeCollection trGraphs(trOut, "Graph");
		//foreach(TreeNode trGraph in trGraphs)
			//trGraph.Reset(bKeepAttrib);
		/////end FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT	
		/////end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	//}
	///end XOP_NEED_SUPPORT_CHANGE_FUNCTION
	
	///end CLEAR_OUT_TABLES_BEFORE_CALC_WHEN_DO_CHANGE_PARAMS
	virtual bool	OnBeforeCalcMultiDataLoop(TreeNode& trOp, const DataRange& drInput, int nTotalNumData, vector<int>& vFactorSizes) {return false;}//CPY 12/6/04 SHOW_RANGE_TO_LABEL_FOR_MULTIPLE_RANGE_ON_SAME_DATA
	virtual void	OnAfterCalculations(TreeNode& trOperation) { }
	/// ML 11/13/2006 THEME_DIGITS_PARAMETERS_TBL
	//virtual void	OnAfterCreateReport(TreeNode& trOperation, Worksheet& wksReport, DataRange& rngInput, bool bNewResultBookCreatedHidden) {}
	virtual void	OnAfterCreateReport(TreeNode& trOperation, Worksheet& wksReport, DataRange& rngInput, DataRange &rgReportSheetOutput, int nExeMode, bool bNewResultBookCreatedHidden, int nTotalNumData = 0) {}
	/// end THEME_DIGITS_PARAMETERS_TBL
	//----
	
	virtual bool IsEnableInsertResultColumnsToSourceData(int nOption) {return false;}//----- CPY 10/2/05 DESC_STATS_ON_ROWS_NEED_REPORT_TO_SOURCE, moved here from wksReportOperation


protected:	
	virtual	string GetDlgTitle(const TreeNode& trOp)
	{
		///Cheney 2007-4-20 OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
		//return getAnalysisName(trOp, true);
		return GetAnalysisName(trOp, true);
		///end OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
	}
	
	virtual string GetResultDescription(const TreeNode& trOperation, bool bLong = true)
	{
		if(bLong)
		{
			///Cheney 2007-4-20 OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
			//return getAnalysisName(trOperation, true);
			return GetAnalysisName(trOperation, true);
			///end OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
		}
		///Cheney 2007-4-20 OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
		//return getAnalysisName(trOperation, false);
		return GetAnalysisName(trOperation, false);
		///end OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
	}
	//virtual bool GetCustomGraphTypeName(string& strName) {return false;}  /// Iris 9/10/04 OUTPUT_ADD_2ND_GRAPH
	virtual bool GetCustomGraphTypeName(string& strName, int nIndex = 0) {return false;}  
	//--- CPY 9/9/04 QA70-6682 SETTINGS_THEME_FILE_SAVE_LOAD
public:
	virtual string GetThemeFilePrefix(const TreeNode& trOp = NULL)
	{
		string strThemeName;
		if(trOp)
			strThemeName = GetClassOptionName(trOp);
		else
		{	
			Tree	mytree;
			GetTree(mytree);
			strThemeName = GetClassOptionName(mytree);
		}
		return strThemeName;	
	}
	//---
	
	///Jasmine 04/16/08 MOVE_UPDATE_MODEL_CODES_IN_FITNL_CLASS
	virtual bool UpdateModelNote(TreeNode& trTable, const TreeNode& trOperation)
	{
		//Model note only needed in NL Fit
		if(!trTable)
			return false;
		
		if(trTable.Model)
			trTable.Model.Remove();
		
		return true;
	}
	///End MOVE_UPDATE_MODEL_CODES_IN_FITNL_CLASS
	
	/// Iris 8/14/2008 QA80-12017-S2 ADD_PARAM_NUM_DATA_NUM_TO_NOTE_TABLE
	// NumFuncParams, NumDerivParams, NumDataSets nodes only used in NLFit
	virtual bool UpdateNumParamsDatasetsNote(TreeNode& trTable, int nTotalNumData, const TreeNode& trOperation)
	{		
		if(trTable.NumFuncParams)
			trTable.NumFuncParams.Remove();
		if(trTable.NumDerivParams)
			trTable.NumDerivParams.Remove();
		if(trTable.NumDataSets)
			trTable.NumDataSets.Remove();
		return true;
	}
	///end ADD_PARAM_NUM_DATA_NUM_TO_NOTE_TABLE
	
	///Arvin 10/27/06 FITTING_FUNCTION_MODEL_IN_REPORT
	virtual string GetResultModel(const TreeNode& trOperation)
	{
		///Cheney 2007-4-20 OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
		//return getAnalysisName(trOperation, true);
		return GetAnalysisName(trOperation, true);
		///end OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
	}
	///end FITTING_FUNCTION_MODEL_IN_REPORT
	
	//nOption < 0 will get from class tree, otherwise will use as is
	string GetClassOptionName(const TreeNode& trOp, int nOption = -1) 
	{
		string strClassName = GetClassName();
		if(nOption < 0)
			nOption = GetOptionIndex(trOp.GUI);
	
		if(nOption)
			strClassName.Format("%s_%d", GetClassName(), nOption);
		
		return strClassName;
	}
	
///Cheney 2007-4-20 OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
//ShowDlg overloaded in wksOperation,
//but it can not access private member in base class
protected:	
//private:
	//string getAnalysisName(const TreeNode& trOp, bool bByOption)
	string GetAnalysisName(const TreeNode& trOp, bool bByOption)
///end OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
	{
		if(!bByOption)
			//----- CPY 9/30/07 FIX_CHENEY_MODIFY_TITLE_AS_MAX_SAID
			//return GetAnalysisName();
			return GetDlgDescription();
			//-----
		
		int nOption = GetOptionIndex(trOp.GUI);
		return GetAnalysisName(nOption);
	}
	//----- CPY 9/30/07 FIX_CHENEY_MODIFY_TITLE_AS_MAX_SAID
	// I have replaced all Cheney's change from GetAnalysisName to GetDlgDescription
	virtual string GetDlgDescription(int nOption = -1) {return "";}
	//-----
protected:	
	virtual string GetAnalysisName(int nOption = -1) {return GetClassName();}
	
	virtual int		GetHelpID() {ASSERT(FALSE); return -1;}		//------ Folger 11/14/07 MAP_OPERATION_DIALOG_HELP
	
	virtual string GetResultCurveBookName(TreeNode& trOperation, int nDataIndex = 0, int nOption = -1, bool bSeparateSheetForDataset = false) {return "";}

	/**
			It retrieves the event function for GetNBox.
	*/
	virtual	PEVENT_FUNC	GetEventFunction()
	{
		//ASSERT(FALSE);	// must be overridden /// Iris 11/10/06 not override it in most places
		return NULL;
	}
	
	//---- Iris 11/10/06 REMOVE_TRY_BUTTON_FOR_ANALYSIS_STATS_DLG
	virtual PAPPLY_FUNC GetApplyEventFunction()
	{
		return NULL;
	}
	//----
	
	///Iris 01/20/05 CLEANUP_CONSTRUCT_ADD_GRAPH
	////--- CPY 5/6/04 QA70-6367 HISTOGRAM_GRAPHS
	///// Iris 9/13/04 OUTPUT_ADD_2ND_GRAPH
	////void ConstructAddGraph(TreeNode& trOperation)
	//void ConstructAddGraph(TreeNode& trOperation, int nIndex = 0);  
	//----- CPY 2/6/06 MULTI_DATA_INDEPENDENT_VS_CONSOLIDATED_REPORT
	/*
	//---
	//----- CPY 6/11/04 APPEND_REPORT_SHEET
	// must be overriden:
	virtual	DWORD	GetDataRules(const TreeNode& trOperation, bool bIgnoreCombineInfo = false)
	{
		ASSERT(FALSE);
		return 0;
	}
	*/
	string GetReportSheetsFromInputData(const TreeNode& trGUI)
	{
		string str;
		DataRange drTemp;
		drTemp.Create(trGUI.InputData, FALSE);
		int nDataCount = 0;//drTemp.GetNumData(GetRules());
		for(int ii = 0; ii < nDataCount; ii++)
		{
		}
		drTemp.Destroy();
		return str;
	}
protected:
	DWORD CheckDataRules(TreeNode& trOp, DWORD dwRules, bool bIgnoreCombineInfo);
	bool IsOutputScriptWindow(const TreeNode& trGUI)
	{
		/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//TreeNode tr = trGUI.Output.Report.DumpScriptWindow;
		TreeNode tr = OP_GUI_OUTPUT_TO_SCRIPT_WND_CHECKBOX(trGUI);
		///end OP_DLG_NEW_STRUCTURE
		
		if(tr)
			return tr.nVal;
		return error_report("trGUI.Output.Report.DumpScriptWindow missing");
	}
	bool IsOutputNotesWindow(const TreeNode& trGUI, string& strNoteName)
	{
		/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//TreeNode tr = trGUI.Output.Report.DumpNotesWindow;
		TreeNode tr = OP_GUI_OUTPUT_TO_NOTES_CHECKBOX(trGUI);
		///end OP_DLG_NEW_STRUCTURE
		
		if(tr)
		{
			strNoteName = tr.strVal;
			///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
			//if(strNoteName.CompareNoCase(STR_NONE) == 0)
			///------ Folger 02/16/09 QA80-13124 PDS_IN_OPJ_THAT_SAVED_IN_NONENLISH_ORIGIN_FAILS_TO_BE_RECOGNISZED_IN_ENGLISH_ORIGIN
			//if ( compare_string_localization(strNoteName, STR_NONE_E, true) )
			if ( PDS_NONE == okutil_cvt_str_to_predefined_type(strNoteName) )
			///------ End PDS_IN_OPJ_THAT_SAVED_IN_NONENLISH_ORIGIN_FAILS_TO_BE_RECOGNISZED_IN_ENGLISH_ORIGIN
			///---END CLEAN_LOCALIZATION_CODE
				return false;
			return true;
		}
		return error_report("trGUI.Output.Report.DumpNotesWindow missing");
	}
	
	/// ML 7/27/2004 QA70-6667 RESULTS_LOG_AS_GRID
	bool IsOutputToResultsLog(const TreeNode& trGUI)
	{
		/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//TreeNode tr = trGUI.Output.Report.AddReportToResultsLog;
		TreeNode tr = OP_GUI_OUTPUT_TO_RESULT_LOG_CHECKBOX(trGUI);
		///end OP_DLG_NEW_STRUCTURE
		
		if(tr)
			return tr.nVal;
		return error_report("trGUI.Output.Report.AddReportToResultsLog missing");
	}
	/// end RESULTS_LOG_AS_GRID	
	///Arvin 10/16/06 MOVE_TO_SUBCLASS
	virtual bool GUIPrepareOutputBranch(TreeNode& trGUI, Worksheet& wksReport = NULL){ return false;}
	///end MOVE_TO_SUBCLASS
	//-----
	
	//---------------------------------------------------------------
	// GUI tree common nodes added to the bottom
	virtual void ConstructAddCommonTop(TreeNode& trGUI)
	{
		GETN_USE(trGUI)
		//GETN_COLOR(CurveColor, "Curve color", 1)
		//--- CPY 07/24/06 QA70-8847 COLUMN_FORMULA_FROM_ORIGIN_C_REVAMP
		//GETN_CHECK(AutoUpdate,_L("Auto Update"), true)	GETN_ID(IDE_AUTO_UPDATE)	///Forest 09/11/04 QA70-6682 SETTINGS_THEME_FILE_SAVE_LOAD
		/// Hong 11/07/07 v.8.0742 FIX_ERROR_LOCALIZED
		//GETN_LIST(AutoUpdate, _L(STR_RECALCULATE), AU_ON_COMMAND, _L(STR_AU_COMBO)) GETN_ID(IDE_AUTO_UPDATE) /// YuI 11/09/06 added GETN_ID
		GETN_LIST(AutoUpdate, GetLocalized(STR_RECALCULATE), AU_ON_COMMAND, GetLocalized(STR_AU_COMBO)) GETN_ID(IDE_AUTO_UPDATE) /// YuI 11/09/06 added GETN_ID
		/// end FIX_ERROR_LOCALIZED
		GETN_SEPARATOR_LINE
		//--- end COLUMN_FORMULA_FROM_ORIGIN_C_REVAMP
	}
	virtual void ConstructAddCommonBottom(TreeNode& trGUI) { }
	//---- CPY 6/10/04 NO_MORE_DEFAULT_FROM_OP
	// default is now handled in GetN level
	/*
	// return true only if successfully init from default settings file
	// this is typically called after Construct filled with system default settings
	//
	virtual bool GetGUIDefaultSettings(TreeNode& trOp, int nOption = -1)
	{
		string strClassOptionName = GetClassOptionName(trOp, nOption);
		Tree trDefault;
		out_str("CPY 1/15/04, Wait for TD to add class member in separate CPP file");
		return false;
	}
	*/
	//---- CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH
	/*
	//---------------------------------------------------------------
	virtual bool IsOpenGUIOnlyShiftDown()
	{
		DWORD dwVal;
		GetRegistrySettings(dwVal);
		if(!(dwVal & 0x00000001)) // ShiftShow Check, will move to oc_const.h later
		{
			return FALSE;	// to tell Origin to call Edit()
		}
		
		return TRUE;
	}
	*/
	//----	
	
	//---------------------------------------------------------------
	//---------------------------------------------------------------
	// for class that support multiple menu items, return the current
	// setting, should be 0,1,2,3 etc
	virtual int	GetOptionIndex(const TreeNode& trGUI)
	{
		return 0;//return tree_node_get_int(trOp.Operation.Option, 0);
	}
	
	
	//---------------------------------------------------------------
	/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
	/*

	BOOL	GetRegistrySettings(DWORD& dwVal, LPCSTR lpcszKey = NULL)
	{
		Tree	mytree;
		GetTree(mytree);
		string strClassName = GetClassOptionName(mytree);
		
		Registry reg(HKEY_CURRENT_USER);
		string strKey = GetRegKey() + "\\Classes\\" + strClassName;
		string strValueName = lpcszKey;
		if(strValueName.IsEmpty())
			strValueName = "GUI"; 
		
		dwVal = 0;
		if(reg.GetValue(strKey, strValueName, dwVal))
			return TRUE;
		
		return FALSE;
	}
	///Forest 09/13/04 QA70-6682 SETTINGS_THEME_FILE_SAVE_LOAD
	BOOL	GetRegistrySettings(string& strVal, LPCSTR lpcszKey = NULL)
	{
		Tree	mytree;
		GetTree(mytree);
		string strClassName = GetClassOptionName(mytree);
		
		Registry reg(HKEY_CURRENT_USER);
		string strKey = GetRegKey() + "\\Classes\\" + strClassName;
		string strValueName = lpcszKey;
		if(strValueName.IsEmpty())
			strValueName = "Theme"; 
		
		strVal = "";
		if(reg.GetValue(strKey, strValueName, strVal))
			return TRUE;
		
		return FALSE;
	}	
	
	//void	SetRegistrySettings(string& strVal, LPCSTR lpcszKey = NULL)///Forest 01/25/04 CHANGE_PROTOTYPE_ACCORDING_TO_ML'S_ADVICE
	void	SetRegistrySettings(const string& strVal, LPCSTR lpcszKey = NULL)
	{
		Tree	mytree;
		GetTree(mytree);
		string strClassName = GetClassOptionName(mytree);
		
		Registry reg(HKEY_CURRENT_USER);
		string strKey = GetRegKey() + "\\Classes\\" + strClassName;
		string strValueName = lpcszKey;
		if(strValueName.IsEmpty())
			strValueName = "Theme"; 
		
		reg.SetValue(strKey, strValueName, strVal);
	}
	*/
	
	BOOL	GetRegistrySettings(DWORD& dwVal, LPCSTR lpcszKey = NULL);
	BOOL	GetRegistrySettings(string& strVal, LPCSTR lpcszKey = NULL);
	void	SetRegistrySettings(const string& strVal, LPCSTR lpcszKey = NULL);
	/// end XF_THEME_SUPPORT
	///End 	SETTINGS_THEME_FILE_SAVE_LOAD
	
	//---------------------------------------------------------------
	void	AddClassInfo(TreeNode& trOperation)
	{
		if(trOperation.GUI.IsValid())
		{
			string strClassName = GetClassOptionName(trOperation);
			
			trOperation.GUI.SetAttribute(STR_CLASS_NAME, strClassName);
		}
	}
	//----- CPY 9/23/04 MOVE_SET_TREE_TO_OC_ONLY
	/*
	//---------------------------------------------------------------
	void	OnSetTree(TreeNode& trOperation)
	{
		OnSetTree_base(trOperation);
	}
	// waiting to calling of base class
	void	OnSetTree_base(TreeNode& trOperation)
	{
		trOperation.Operation.UID.nVal = GetUID(TRUE);
		return;
	}
	*/
public:
	//virtual
	///Arvin 10/16/06 MOVE_TO_OPERATION_FILE
	//virtual
	virtual void	SetTree(TreeNode& trOperation)
	{
		trOperation.Operation.UID.nVal = GetUID(TRUE);
		OperationBase::SetTree(trOperation);
	}
	///end MOVE_TO_OPERATION_FILE
	
	/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
	/// YuI 08/15/06 MORE_WORK_ON_STATISTICAL_PLOTS
	//	virtual bool	UpdatePercentileDataset(DataPlot& dp, int nDataIndex)			{return false;}
	virtual bool	UpdateStatsTree(TreeNode& trStats, int nDataIndex, BOOL& bUpdated)		{return false;}
	/// end MORE_WORK_ON_STATISTICAL_PLOTS
	virtual bool	GetTickLabel(DataPlot& dp, int nDataIndex, string& strLabel)	{return false;}
	/// end PICTURE_IN_REPORT_IMPROVEMENT
	
	///Joseph 01/29/07	ADD_OPERATION_ERRMSG_LINE
	virtual PEVENT_GETN GetNewEventFunction()
	{
		return NULL;
	}
	///End ADD_OPERATION_ERRMSG_LINE
protected:
	//----- end CPY 9/23/04 MOVE_SET_TREE_TO_OC_ONLY
		

	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME, want GUI tree as input in DescStats::GetResultSheetName
	//virtual string	GetResultSheetName()				
	virtual string	GetResultSheetName(TreeNode& trGUI)				
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME   
	{
		return GetClassName() + "1";
	}
	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	virtual string GetResultBookName(TreeNode& trGUI)
	{
		return "AnalysisReport1";
	}
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME	

	// When analysis is done for the first time, this is called
	// to init the GUI part of the tree with the appropriate
	// current data selection.
	/// Hong 09/04/09 QA80-14258 HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING
	//virtual bool	InitFromSelection(TreeNode &trOperation);
	/**$
	Return:
		1 for success, 0 for init fail, -1 for fatal error, procedure should terminate
	*/
	virtual int		InitFromSelection(TreeNode &trOperation);
	/// end HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING

	///Kevin 11/21/05	SET_EVENT_FOR_INPUT_DATA
	virtual	bool	OnInputDataSelectionChange(TreeNode& trOperation);

protected:	

	TreeNode GetTreeNode_Notes(TreeNode &trOperation) { return trOperation.Calculation.Notes; }
		
	/// Iris 10/14/04 SHOW_MODELESS_GETNBOX
	//----- CPY 04/18/2007 AFTER_APPLIED_THEME_GUI_ERR_WILL_SHOW_DLG_BROKE_XF_COMPILE
	//virtual	bool ShowDlg(TreeNode& trOperation, BOOL bChangeParams);
	virtual	bool ShowDlg(TreeNode& trOperation, BOOL bChangeParams) { return false;}
	//-----
	//virtual		bool ShowDlg(TreeNode& trOperation, BOOL bChangeParams, bool bIsModeless = false, DWORD* pDlgPtr = NULL);

	//-------- CPY 6/8/04 ADD_INPUT_TABLE
	virtual	void	UpdateDataSourceInReportingHeader(TreeNode &trInputTable, const vector<string> &vstrFactors, int ii, LPCSTR lpcszXLabel = NULL, int numSubRanges = 0, DWORD dwRules = 0) {}
	/* WKSOP
	{
		string		strLabel = _L("Data");
		if ( 1 < numSubRanges )
		{
			AddCombinedDataSourcesToReportInputTable(trInputTable, vstrFactors, ii, strLabel, numSubRanges, dwRules);
			return;
		}
		
		TreeNode	trRow = AddXDataSourceToReportInputTable(trInputTable, vstrFactors, ii, strLabel, 0, numSubRanges, dwRules);
		// The Range column:
		AddOneInputDataTableCell(trRow, WKSH_OPERATION_INFO_DATA_SOURCE_RANGE, ii + 1, FALSE, 'G', 'R');
	}
	*/
	virtual	bool	HasX()
	{
		return false;
	}
	
	/// ML 11/2/2005 QA70-8135 MISSING_AND_MASKED_DATA_FOR_XYZ
	///Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
	//virtual	bool	HasZ(TreeNode& trOp)
	virtual	bool	HasZ(TreeNode& trOp, bool *pbHasXIndep = NULL, bool *pbHesYIndep = NULL)
	///end REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
	{
		/// ML 4/5/2007 X_INPUT_MISSING_FROM_INPUT_DATA_TABLE
		if (pbHasXIndep)
			*pbHasXIndep = HasX();
		if (pbHesYIndep)
			*pbHesYIndep = false;
		/// end X_INPUT_MISSING_FROM_INPUT_DATA_TABLE
		return false;
	}
	/// end QA70-MISSING_AND_MASKED_DATA_FOR_XYZ	
	///Arvin 09/03/07 WRONG_WEIGHT_LABEL_IN_MASK_AND_MISSING_DATA_TABLE
	//virtual	string	GetMaskedOrMissingDataTableErrorColumnName()
	virtual	string	GetMaskedOrMissingDataTableErrorWeightColumnName()
	///END WRONG_WEIGHT_LABEL_IN_MASK_AND_MISSING_DATA_TABLE
	{
		return WKSH_OPERATION_INFO_DATA_ERR;
	}
protected:
	
protected:
	//--- CPY 6/8/04 ADD_INPUT_TABLE
private:
	uint addTableStringCommonBits(uint nVal, bool bTranspose, bool bColHeadings, bool bAutoWidth)
	{
		if(bTranspose)
			nVal |=GETNBRANCH_TRANSPOSE ;
		if(!bColHeadings)
			nVal |= GETNBRANCH_HIDE_COL_HEADINGS;
		if(bAutoWidth)
			nVal |= GETNBRANCH_FIT_COL_WIDTH | GETNBRANCH_FIT_ROW_HEIGHT;
		return nVal;
	}

protected:
	
	TreeNode GetOptionalTables(const TreeNode& trGUI);

protected:
	/// ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS
	//string GetTableStringMaskedData(bool bSubLevel);
	int GetTableStringMaskedOrMissingData(bool bSubLevel);
	/// end GETTING_MISSING_VALUES_AND_ROWS
	string GetTableStringMainResultsLog(/*bool bIsTable = true*/)
	{
		uint nn = GETNBRANCH_HIDE_ROW_HEADINGS | GETNBRANCH_RESIZE;	
		
		//---- Iris 9/13/04 ADD_TABLE_BIT_TO_TREETABLE
		//if(bIsTable)
			//nn |= GETNBRANCH_TABLE;		
		nn = addTableStringCommonBits(nn, false, false, true);
		return ftoa(nn);
	}
	string GetTableStringMain(bool bTranspose = true, bool bColHeadings = false, bool bAutoWidth = true,
		bool bRowHeadingHide = true, bool bWritable = false)
	{
		///---- CPY RVD 3/23/2006 QA70-8359 TABLE_FOOTNOTE
		//uint nn = GETNBRANCH_OPEN | GETNBRANCH_RESIZE;
		uint nn = GETNBRANCH_OPEN;
		nn |= COMMON_TABLE_STR_BITS;
		//-----
		
		if(bRowHeadingHide)
			nn |= GETNBRANCH_HIDE_ROW_HEADINGS;
		
		/// ML 11/23/2004 QA70-6845 LINKS_CLIPBOARD_WORK
		if ( bWritable )
			nn |= GETNBRANCH_WRITABLE;
		/// end LINKS_CLIPBOARD_WORK
		
		//---- Iris 9/13/04 ADD_TABLE_BIT_TO_TREETABLE
		//if(bIsTable)
			//nn |= GETNBRANCH_TABLE;	
		nn = addTableStringCommonBits(nn, bTranspose, bColHeadings, bAutoWidth);
		return ftoa(nn);
	}
	int GetTableStringSupport(bool bTranspose = true, bool bColHeadings = false, bool bAutoWidth = true/*, bool bIsTable = true*/, DWORD dwExtraBits = 0)
	{
		///---- CPY RVD 3/23/2006 QA70-8359 TABLE_FOOTNOTE
		//uint nn = GETNBRANCH_HIDE_ROW_HEADINGS | GETNBRANCH_RESIZE;
		uint nn = GETNBRANCH_HIDE_ROW_HEADINGS;
		nn |= COMMON_TABLE_STR_BITS;
		//-----		

		////---- Iris 9/13/04 ADD_TABLE_BIT_TO_TREETABLE
		//if(bIsTable)
			//nn |= GETNBRANCH_TABLE;
		////----
		//-------- CPY 10/22/04 QA70-7075 MASKED_DATA_REPORTING
		if(dwExtraBits)
			nn |= dwExtraBits;
		//--------
		
		return addTableStringCommonBits(nn, bTranspose, bColHeadings, bAutoWidth);
	}
	int GetTableStringDatasets(bool bColHeadings = true, bool bAutoWidth = true, bool bChangeColLabelsInFlatSheet = true);
	//------ CPY 12/21/04 CLEANUP_ANOVA1_AND_USE_BASE_CLASS_FIX
	bool UpdateTableString(TreeNode& trTable, bool bHasSubTables = false, bool bAlsoSetSubTables = true, int nOneTable = -1, int nTableWithSubTable = -1)
	{
		if(!trTable)
			return false;
		//----- Iris 9/06/05 UPDATE_TABLE_STRING_FUN  can use diff setting for TREE_Table
		//int nOneTable = GetTableStringSupport(false);
		//int nTableWithSubTable = GetTableStringSupport(false);// might be diff, not sure
		if(-1 == nOneTable)
			nOneTable = GetTableStringSupport(false);
		if(-1 == nTableWithSubTable)
			nTableWithSubTable = GetTableStringSupport(false);
		//-----
		if(!bHasSubTables)
		{
			trTable.SetAttribute(TREE_Table, nOneTable);
			return true;
		}
		trTable.SetAttribute(TREE_Table, nTableWithSubTable);
		if(bAlsoSetSubTables)
		{
			foreach(TreeNode trSub in trTable.Children)
				trSub.SetAttribute(TREE_Table, nOneTable);
		}
		return true;
	}
	//------ end CLEANUP_ANOVA1_AND_USE_BASE_CLASS_FIX
	
	
	virtual string GetAdvanSettingsFileName(){ return GetClassName();}	///Frank 4/5/05	GUI_ADVANCED_SETTING_FROM_FILE
	
	virtual bool	InitOutputGUIManagerPointer(const TreeNode& trGUI) { return false; } /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	
public:	
	virtual int	CheckInputData(const TreeNode& trGUI, const TreeNode& trOperation)/// Iris 06/29/06 QA70-8726 CHECK_INPUT_DATA_BEFORE_CALCULATION
	{
		DataRange dr;
		dr.Create(trGUI.InputData, false);
		
		int nNumData = dr.GetNumData(GetDataRules(trOperation));
		if(nNumData <= 0)
			return CER_NO_DATA;	
	
		return 0;
	}

	/// Hong 01/22/08 QA80-10929 LTNL_ACCESS_FITSESSION_PONTER
	virtual void* GetSessionPtr(){ return NULL; }
	/// end LTNL_ACCESS_FITSESSION_PONTER
	
	virtual bool EnableSourceGraphPreview() { return false; } /// Hong 01/24/08 QA80-10929 LT_NLFIT_SUPPORT_SOUURCE_GRAPHPAGE_PREVIEW
	
	virtual bool PrepareFitTypeFromInput(TreeNode& trOp, DataRange& dr, LPCSTR lpcszCateg) { return false; } /// Hong 02/01/08 v8.0798 FIX_CONTANTENATE_FIT_FAIL_WORK

	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	bool GetOutputGUIManagerPointer(OutputGUIManagerBase* pOutputManager) 
	{ 
		if(NULL == m_pOutputManager)
		{
			pOutputManager = NULL;
			return false;
		}
		
		pOutputManager = m_pOutputManager; 
		return true;
	} 
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	
protected:
	OutputGUIManagerBase*		m_pOutputManager; /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	
//--- CPY 7/13/06 FIT_COMMON_PCH_COMPILE_FAILED
/*
/// Thomas 07/13/2006 FIX_MASKED_AND_MISSING_DATA_AUTO_UPDATE_ERROR
private:
	TreeNode checkGetMaskedOrMissingDataNode(TreeNode &trCalc, bool bMissingData);
/// End FIX_MASKED_AND_MISSING_DATA_AUTO_UPDATE_ERROR	
*/

};

typedef Operation* OperationPtr;		/// move form op_tuils.h

//---- CPY 2/5/05
// bits to control 	virtual BOOL	executeWithRange(int nExeMode = OEXEM_ON_CREATE, DWORD dwExecCntrl = 0);
enum {
	OPEXEC_NO_PARAM_INIT = 1, // default will do param init in some analysis like NLFit, if this bit is set, then the op tree is used as is
	///Arvin 01/29/08 GENERATE_REPORT_FOR_LT_NLFit
	OPEXEC_NO_FIT_AGAIN  = 0x0010, 
	OPEXEC_NO_INIT_FROM_OP_AGAIN  = 0x0020,
	///END GENERATE_REPORT_FOR_LT_NLFit
	/// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	OPEXEC_FORCE_CALCUTE_OUTPUT  = 0x0040,
	/// end NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
OPEXEC_LAST_ENTRY};
//----


#define IS_EXE_ON_AUTO_UPDATE(_nExeMode) (OEXEM_ON_AUTOUPDATE_TASK==_nExeMode || OEXEM_ON_AUTOUPDATE_MANUAL == _nExeMode) //CPY 11/16/04

//---- CPY 11/21/04
/// Iris 9/06/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
//bool op_get_output(const OperationBase& op, DataRange& rgOutput, Worksheet& wksOutput, int nOutputIndex) // = OUTPUT_REPORT_SHEET_RNG_INDEX
bool op_get_output(const OperationBase& op, DataRange& rgOutput, Datasheet& dsOutput, int nOutputIndex = OUTPUT_REPORT_SHEET_RNG_INDEX)
{	///Jasmine 01/30/07 SHOULD_CHECK_DATARANGE_DATA_NUM
	if(op.GetOutput(rgOutput, nOutputIndex) && rgOutput.IsValid() && rgOutput.GetNumData())
	{
		int r1, c1, r2, c2;
		if(rgOutput.GetRange(0, r1, c1, r2, c2, dsOutput))
		{
			if(dsOutput)
				return true;
		}
	}
	return false;
}
//----

///Danice 12/13/04 : wkbook organizer needed
bool op_get_input(const OperationBase& op, DataRange& rgInput, Worksheet& wksInput, int nInputIndex)
{	///Jasmine 01/30/07 SHOULD_CHECK_DATARANGE_DATA_NUM
	if(op.GetInput(rgInput, nInputIndex) && rgInput.IsValid() && rgInput.GetNumData())
	{
		int r1, c1, r2, c2;
		if(rgInput.GetRange(0, r1, c1, r2, c2, wksInput))
		{
			if(wksInput)
				return true;
		}
	}
	return false;
}
///end

/// YuI 11/12/08 ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
class	OnBeforeAfterExecuteHelper
{
public:
	OnBeforeAfterExecuteHelper(OperationBase& op, int nExeMode)
	{
		m_op = op;
		m_nExeMode = nExeMode;
		op.OnBeforeExecute(m_nExeMode);
	}
	
	~OnBeforeAfterExecuteHelper()
	{
		if( m_op )
			m_op.OnAfterExecute(m_nExeMode);			
	}
private:
	OperationBase 	m_op;
	int				m_nExeMode;
};

/// end ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM

#endif //_OPERATION_H
